<?php

use Core\App;

if (! function_exists('pre')) {

    function pre($var)
    {

        echo '<pre>';

        print_r($var);

        echo '<pre>';
    }
}

if (! function_exists('url')) {

    function url($path)
    {

        return rep('\\', '/', baseUrl().$path);
        //        return rep('\\', '/', baseUrl().DS.APP_DIR.$path);

    }
}

if (! function_exists('replace')) {

    /**
     * @param $string
     * @param $what
     * @param $with
     * @return string
     */

    function rep($what, $with, $string)
    {

        return str_replace($what, $with, $string);
    }
}

if (! function_exists('assets')) {

    function assets($path)
    {

        $path = rep('\\', '/', baseUrl().'/public'.$path);

        return $path;
    }
}

if (! function_exists('redirectTo')) {

    function redirectTo($path, $out = false)
    {
        header('location: '.($out ? $path : baseUrl().$path));

        exit;
    }
}

if (! function_exists('baseUrl')) {

    function baseUrl()
    {

        $app = App::getInstance();

        return $app->get('request')->getbaseURL();
    }
}

if (! function_exists('_e')) {

    function _e($value)
    {

        return htmlspecialchars($value);
    }
}

if (! function_exists('show_tree')) {

    function show_tree($cats, $level = 0, $target_id = null, $id = null)
    {

        $indent = str_repeat('+', $level);

        foreach ($cats as $row) {

            $hash = $row['parent_id'] == 0 ? ' (تصنيف رئيسي) ' : '';

            if ($id != $row['id']) {

                if ($row['children']) {
                    if ($target_id == $row['id']) {
                        echo '<option value="'.$row['id'].'" selected>'.$indent.' '.$row['name'].$hash.'</option >';
                    } else {
                        echo '<option value="'.$row['id'].'">'.$indent.' '.$row['name'].$hash.'</option >';
                    }
                    show_tree($row['children'], $level + 1, $target_id, $id);
                } else {
                    if ($target_id == $row['id']) {
                        echo '<option value="'.$row['id'].'" selected>'.$indent.' '.$row['name'].$hash.'</option >';
                    } else {
                        echo '<option value="'.$row['id'].'">'.$indent.' '.$row['name'].$hash.'</option >';
                    }
                }
            } else {
                if ($row['children']) {
                    show_tree($row['children'], $level + 1, $target_id, $id);
                }
            }
        }
    }
}

if (! function_exists('mto')) {

    function mto($path)
    {

        return ROOT.DS.APP_DIR.DS.str_replace(['/', '\\'], DS, $path);
    }
}

if (! function_exists('seo')) {

    function seo($string)
    {

        $string = trim($string);

        $string = preg_replace('#[^\w]#u', ' ', $string);

        $string = preg_replace('#[\s]+#', ' ', $string);

        $string = str_replace(' ', '-', $string);

        return trim($string, '-');
    }
}

if (! function_exists('cut')) {

    function cut($string, $length, $append = "&hellip;")
    {

        $string = trim($string);

        if (mb_strlen($string) > $length) {

            $string = wordwrap($string, $length);

            $string = explode("\n", $string, 2);

            $string = $string[0].$append;
        }

        return $string;
    }
}

if (! function_exists('isLink')) {

    function isLink($url)
    {

        if ($parts = parse_url($url)) {

            if (! isset($parts["scheme"])) {

                $url = "http://$url";
            }
        }

        if (filter_var($url, FILTER_VALIDATE_URL, FILTER_FLAG_PATH_REQUIRED)) {

            return true;
        } else {

            return false;
        }
    }
}
if (! function_exists('generateRandom')) {

    function generateRandom($length = 5)
    {
        return substr(base64_encode(uniqid(mt_rand())), 0, $length);
    }
}


